/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.signature;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatSignatureFichier;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class GenererSignatureFichier {
    private static Logger log = Logger.getLogger(GenererSignatureFichier.class);

    public static Resultat traitementP11(PKCS11 pKCS11, long l, long l2, long l3, FileInputStream fileInputStream) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                if (fileInputStream != null) {
                    boolean bl;
                    byte[] byArray;
                    ResultatSignatureFichier resultatSignatureFichier;
                    block15: {
                        resultatSignatureFichier = new ResultatSignatureFichier("G\u00e9n\u00e9ration de la signature d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (Initialisation (C_SignInit))", "G\u00e9n\u00e9ration de la signature d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (G\u00e9n\u00e9ration (C_SignUpdate))", "G\u00e9n\u00e9ration de la signature d'un fichier avec " + TraitementsUtil.getNomAlgo(l2) + " (Finalisation (C_SignFinal))");
                        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM();
                        cK_MECHANISM.mechanism = l2;
                        byArray = null;
                        bl = false;
                        try {
                            pKCS11.C_SignInit(l, cK_MECHANISM, l3);
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatSignatureFichier.setCodeRetour(pKCS11Exception.getErrorCode());
                            bl = true;
                            resultatSignatureFichier.setCodeRetour2(-1L);
                            resultatSignatureFichier.appendOperation2(" NON EXECUTEE!");
                            resultatSignatureFichier.setCodeRetour3(-1L);
                            resultatSignatureFichier.appendOperation3(" NON EXECUTEE!");
                        }
                        try {
                            if (bl) break block15;
                            int n = 0;
                            boolean bl2 = false;
                            int n2 = 1024;
                            while (!bl2) {
                                n = 0;
                                byte[] byArray2 = new byte[n2];
                                n = fileInputStream.read(byArray2, 0, n2);
                                if (n != -1) {
                                    pKCS11.C_SignUpdate(l, byArray2);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            log.error((Object)("Probleme d'entree/sortie\n" + iOException.getMessage()));
                            bl = true;
                            resultatSignatureFichier.setCodeRetour3(-1L);
                            resultatSignatureFichier.appendOperation3(" NON EXECUTEE!");
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                            resultatSignatureFichier.setCodeRetour2(pKCS11Exception.getErrorCode());
                            bl = true;
                            resultatSignatureFichier.setCodeRetour3(-1L);
                            resultatSignatureFichier.appendOperation3(" NON EXECUTEE!");
                        }
                    }
                    try {
                        if (!bl && (byArray = pKCS11.C_SignFinal(l)) != null) {
                            resultatSignatureFichier.setSignature(TraitementsUtil.getHexadecimal(byArray, 16));
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                        resultatSignatureFichier.setCodeRetour3(pKCS11Exception.getErrorCode());
                    }
                    return resultatSignatureFichier;
                }
                log.error((Object)"Le fichier est illisible");
                throw new ExceptionTraitement(29, "Le fichier est illisible");
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(29, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(29, "Une erreur inattendue est survenue");
        }
    }
}

